package gov.va.med.mhv.integration.phr.service.mvi.model;

/**
 * @author Rob Murtha
 */
public class Acknowledgement {
    private String typeCodeCode;
    private String targetMessageId;
    private String targetMessageRoot;
    private String acknowledgmentDetailText;


    public boolean isOk() {
        return typeCodeCode!=null && typeCodeCode.equals("AA");
    }

    public String getTypeCodeCode() {
        return typeCodeCode;
    }

    public void setTypeCodeCode(String typeCodeCode) {
        this.typeCodeCode = typeCodeCode;
    }

    public String getTargetMessageId() {
        return targetMessageId;
    }

    public void setTargetMessageId(String targetMessageId) {
        this.targetMessageId = targetMessageId;
    }

    public String getTargetMessageRoot() {
        return targetMessageRoot;
    }

    public void setTargetMessageRoot(String targetMessageRoot) {
        this.targetMessageRoot = targetMessageRoot;
    }

    public String getAcknowledgmentDetailText() {
        return acknowledgmentDetailText;
    }

    public void setAcknowledgmentDetailText(String acknowledgmentDetailText) {
        this.acknowledgmentDetailText = acknowledgmentDetailText;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Acknowledgement)) return false;

        Acknowledgement that = (Acknowledgement) o;

        if (acknowledgmentDetailText != null ? !acknowledgmentDetailText.equals(that.acknowledgmentDetailText) : that.acknowledgmentDetailText != null)
            return false;
        if (targetMessageId != null ? !targetMessageId.equals(that.targetMessageId) : that.targetMessageId != null)
            return false;
        if (targetMessageRoot != null ? !targetMessageRoot.equals(that.targetMessageRoot) : that.targetMessageRoot != null)
            return false;
        if (typeCodeCode != null ? !typeCodeCode.equals(that.typeCodeCode) : that.typeCodeCode != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = typeCodeCode != null ? typeCodeCode.hashCode() : 0;
        result = 31 * result + (targetMessageId != null ? targetMessageId.hashCode() : 0);
        result = 31 * result + (targetMessageRoot != null ? targetMessageRoot.hashCode() : 0);
        result = 31 * result + (acknowledgmentDetailText != null ? acknowledgmentDetailText.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Acknowledgement{" +
                "typeCodeCode='" + typeCodeCode + '\'' +
                ", targetMessageId='" + targetMessageId + '\'' +
                ", targetMessageRoot='" + targetMessageRoot + '\'' +
                ", acknowledgmentDetailText='" + acknowledgmentDetailText + '\'' +
                '}';
    }
}

/*
            <acknowledgement>
                <typeCode code="AE"/>
                <targetMessage>
                    <id extension="MCID-20111110101556-001" root="2.16.840.1.113883.4.349"/>
                </targetMessage>
                <acknowledgementDetail>
                    <text>Correlation Does Not
                        Exist:gov.va.med.person.idmgmt.QualifiedIdentifierImpl@1d657d12[8201,PI,USVHA,200MH]
                    </text>
                </acknowledgementDetail>
            </acknowledgement>

*/